﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using System.Web.Security.AntiXss;
public partial class LabKitInProcessOrders : BasePage
{
    private int OrderType;
    protected void Page_Load(object sender, EventArgs e)
    {
   }


    protected override void OnInitComplete(EventArgs e)
    {

        GetOrderType();
        if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.Tracking))
        {
            ObjectDataSourceLabKitOrders.SelectMethod = "GetOrderedKitOrders";
            ObjectDataSourceLabKitOrders.SelectCountMethod = "GetOrderedKitOrdersCount";
            GridViewLabKitOrders.Columns[9].Visible = false;
            GridViewLabKitOrders.Columns[10].Visible = false;
            //btnSave.Visible = true;
        }
        if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.Received))
        {
            ObjectDataSourceLabKitOrders.SelectMethod = "GetLabKitsReturned";
            ObjectDataSourceLabKitOrders.SelectCountMethod = "GetLabKitsReturnedCount";
            GridViewLabKitOrders.Columns[10].Visible = false;
        }
        if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.Voided))
        {
            ObjectDataSourceLabKitOrders.SelectMethod = "GetLabKitsCanceled";
            ObjectDataSourceLabKitOrders.SelectCountMethod = "GetLabKitsCanceledCount";
            GridViewLabKitOrders.Columns[9].Visible = false;
        }
        base.OnInitComplete(e);
    }

    protected override void OnInit(EventArgs e)
    {

        //GetOrderType();
        //if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.Ordered))
        //{
        //    ObjectDataSource1.SelectMethod = "GetOrderedKitOrders";
        //    GridView1.Columns[7].Visible = false;
        //    GridView1.Columns[8].Visible = false;
        //    btnSave.Visible = true;
        //}
        //if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.Received))
        //{
        //    ObjectDataSource1.SelectMethod = "GetLabKitsReturned";
        //    GridView1.Columns[8].Visible = false;
        //}
        //if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.Canceled))
        //{
        //    ObjectDataSource1.SelectMethod = "GetLabKitsCanceled";
        //    GridView1.Columns[7].Visible = false;
        //}
        base.OnInit(e);
    }
    protected void SelectActivity(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewLabKitOrders.SelectedIndex = index;
            Int32 ActivityId = Convert.ToInt32(GridViewLabKitOrders.SelectedDataKey.Values[0]);
            Response.Redirect("LabKitDetails.aspx?ActivityId={0}", ActivityId);
        }
    }

    protected void ObjectDataSource1_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        if (e.ReturnValue != null && !e.ReturnValue.GetType().IsValueType)
            if (((IEnumerable<LabInProcessKitDetails>)e.ReturnValue).Count() == 0)
        {
            GridViewLabKitOrders.EmptyDataText="No records found for the " + Enum.GetName(typeof(WorkflowCaseActivityStatus), OrderType).AddSpacesToCamelCase() + " lab kits.";
            
                btnSave.Visible = false;
        }
    }

    private void GetOrderType()
    {
        if (!IsPostBack)
        {
            OrderType = Convert.ToInt16(AntiXssEncoder.HtmlEncode(Request.QueryString["OrderType"],false));
            //ViewState["OrderType"] = OrderType;
            //TODO - Move breadcrumb logic to menubuilder and master page. Added here to avoid error out in Referral pages.
            BreadCrumbLabel.Text = BreadCrumbLabel.Text + Enum.GetName(typeof(WorkflowCaseActivityStatus), OrderType).AddSpacesToCamelCase();
        }
        //For paging
        //OrderType = Convert.ToInt16(ViewState["OrderType"]);
        else
        {
            OrderType = Convert.ToInt16(AntiXssEncoder.HtmlEncode(Request.QueryString["OrderType"], false));
        }
    }

    protected void ButtonOK_Click(object sender, EventArgs e)
    {
        GridViewLabKitOrders.PageIndex = 0;
    }

    public string DisplayFormatOrderedDate(DateTime? date)
    {
        if (date.HasValue)
            return date.Value.ToString("d");
            
        else
            return "Used Stock";

    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "LabKitOrders";
    }

    public override string AppObjectCode()
    {
        return "LabKitOrders";
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        Response.Redirect("LabKitsReport.aspx");
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        ButtonOK_Click(sender, e);
    }
}
